/*
 * Decompiled with CFR 0.152.
 */
package common.ui;

import com.nokia.mid.appl.calc2.Local;
import common.ui.ButtonPanel;
import common.ui.DisplaySizes;
import common.ui.EditPanel;
import common.ui.UiComponent;
import common.util.Tools;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Button
extends UiComponent {
    public static final int ADD_ID = 0;
    public static final int SUBSTRACT_ID = 1;
    public static final int MULTIPLY_ID = 2;
    public static final int DIVIDE_ID = 3;
    public static final int EQUALS_ID = 4;
    public static final int PERCENTAGE_ID = 5;
    public static final int SQUARE_ID = 6;
    public static final int SQUARE_ROOT_ID = 7;
    public static final int RECIPROCAL_ID = 8;
    public static final int SIN_ID = 9;
    public static final int COS_ID = 10;
    public static final int TAN_ID = 11;
    public static final int ASIN_ID = 12;
    public static final int ACOS_ID = 13;
    public static final int ATAN_ID = 14;
    public static final int FACTORIAL_ID = 15;
    public static final int POWER_ID = 16;
    public static final int LOG_ID = 17;
    public static final int LN_ID = 18;
    public static final int PI_ID = 19;
    public static final int DECIMAL_SEPARATOR_ID = 20;
    public static final int CHANGE_SIGN_ID = 21;
    public static final int LEFT_PARENTHESIS_ID = 22;
    public static final int RIGHT_PARENTHESIS_ID = 23;
    public static final int CLEAR_ID = 24;
    public static final int MEMORY_SAVE_ID = 25;
    public static final int MEMORY_RECALL_ID = 26;
    public static final int SCROLL_UP_ID = 27;
    public static final int SCROLL_DOWN_ID = 28;
    protected static final int DOUGLAS_8_BUTTON_SHADE_SIZE = 3;
    protected static final int DOUGLAS_8_Y_OFFSET_ADD_LABEL_STRING = 2;
    protected static final int DOUGLAS_8_Y_OFFSET_SUBSTRACT_LABEL_STRING = 1;
    protected static final int DOUGLAS_8_Y_OFFSET_EQUALS_LABEL_STRING = 1;
    protected static final int DOUGLAS_8_Y_OFFSET_PERCENTAGE_LABEL_STRING = 1;
    protected static final int DOUGLAS_8_Y_OFFSET_SQUARE_LABEL_STRING = 1;
    protected static final int DOUGLAS_8_Y_OFFSET_SQUARE_ROOT_LABEL_STRING = 3;
    protected static final int DOUGLAS_8_Y_OFFSET_SIN_LABEL_STRING = 1;
    protected static final int DOUGLAS_8_Y_OFFSET_COS_LABEL_STRING = 1;
    protected static final int DOUGLAS_8_Y_OFFSET_TAN_LABEL_STRING = 1;
    protected static final int DOUGLAS_8_Y_OFFSET_FACTORIAL_LABEL_STRING = 1;
    protected static final int DOUGLAS_8_Y_OFFSET_LOG_LABEL_STRING = 1;
    protected static final int DOUGLAS_8_Y_OFFSET_LN_LABEL_STRING = 1;
    protected static final int DOUGLAS_8_Y_OFFSET_DECIMAL_SEPARATOR_LABEL_STRING = -3;
    protected static final int DOUGLAS_8_Y_OFFSET_CHANGE_SIGN_LABEL_STRING = 1;
    protected static final int DOUGLAS_8_Y_OFFSET_CLEAR_LABEL_STRING = 1;
    protected static final int DOUGLAS_8_Y_OFFSET_MEMORY_SAVE_LABEL_STRING = 1;
    protected static final int DOUGLAS_8_Y_OFFSET_MEMORY_RECALL_LABEL_STRING = 1;
    protected static final int PRESSED_TIME = 100;
    protected static final int PRESSED_BUTTON_LABEL_X_OFFSET = 2;
    protected static final int PRESSED_BUTTON_LABEL_Y_OFFSET = 1;
    protected final int buttonType;
    protected ButtonPanel buttonPanel = null;
    protected EditPanel editPanel = null;
    protected Sprite backgroundSprite = null;
    protected Sprite labelSprite = null;
    protected int buttonShadeSize = 0;

    public Button(DisplaySizes displaySize, int buttonType) {
        super(displaySize);
        this.buttonType = buttonType;
        this.backgroundImage = Tools.getInstance().loadImage("/images/standard_button.png");
        try {
            this.backgroundSprite = new Sprite(this.backgroundImage, this.backgroundImage.getWidth() / 3, this.backgroundImage.getHeight());
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        this.backgroundSprite.setFrame(0);
        Image labelImage = null;
        switch (buttonType) {
            case 0: {
                this.label = "+";
                break;
            }
            case 1: {
                this.label = "-";
                break;
            }
            case 2: {
                this.label = "x";
                break;
            }
            case 3: {
                this.label = "\u00f7";
                break;
            }
            case 4: {
                this.label = "=";
                break;
            }
            case 5: {
                this.label = "%";
                break;
            }
            case 6: {
                this.label = "x\u00b2";
                break;
            }
            case 7: {
                this.label = "\u221a";
                break;
            }
            case 8: {
                this.label = "1/x";
                break;
            }
            case 9: {
                this.label = "SIN";
                break;
            }
            case 10: {
                this.label = "COS";
                break;
            }
            case 11: {
                this.label = "TAN";
                break;
            }
            case 12: {
                labelImage = Tools.getInstance().loadImage("/images/math.png");
                this.labelSprite = new Sprite(labelImage, labelImage.getWidth() / 4, labelImage.getHeight());
                this.labelSprite.setFrame(0);
                break;
            }
            case 13: {
                labelImage = Tools.getInstance().loadImage("/images/math.png");
                this.labelSprite = new Sprite(labelImage, labelImage.getWidth() / 4, labelImage.getHeight());
                this.labelSprite.setFrame(1);
                break;
            }
            case 14: {
                labelImage = Tools.getInstance().loadImage("/images/math.png");
                this.labelSprite = new Sprite(labelImage, labelImage.getWidth() / 4, labelImage.getHeight());
                this.labelSprite.setFrame(2);
                break;
            }
            case 15: {
                this.label = "n!";
                break;
            }
            case 16: {
                labelImage = Tools.getInstance().loadImage("/images/math.png");
                this.labelSprite = new Sprite(labelImage, labelImage.getWidth() / 4, labelImage.getHeight());
                this.labelSprite.setFrame(3);
                break;
            }
            case 17: {
                this.label = "LOG";
                break;
            }
            case 18: {
                this.label = "LN";
                break;
            }
            case 19: {
                this.label = "\u03c0";
                break;
            }
            case 20: {
                this.label = Local.getText(27);
                break;
            }
            case 21: {
                this.label = "\u00b1";
                break;
            }
            case 22: {
                this.label = "(";
                break;
            }
            case 23: {
                this.label = ")";
                break;
            }
            case 24: {
                this.label = "C";
                break;
            }
            case 25: {
                this.label = "MS";
                break;
            }
            case 26: {
                this.label = "MR";
                break;
            }
            case 27: 
            case 28: {
                labelImage = Tools.getInstance().loadImage("/images/arrow_large.png");
                this.labelSprite = new Sprite(labelImage);
                break;
            }
            default: {
                this.label = "";
                this.labelSprite = null;
            }
        }
        if (displaySize == DisplaySizes.DOUGLAS_8 || displaySize == DisplaySizes.S60_3_2_SDK || displaySize == DisplaySizes.S60_3_1 || displaySize == DisplaySizes.S60_3_1_OLD) {
            this.font = Font.getFont((int)0, (int)0, (int)0);
            this.buttonShadeSize = 3;
        } else if (displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK) {
            this.font = Font.getFont((int)0, (int)0, (int)0);
            this.buttonShadeSize = 3;
        }
        this.width = this.backgroundSprite.getWidth();
        this.height = this.backgroundSprite.getHeight();
    }

    public synchronized void paint(Graphics g) {
        super.paint(g);
        if (this.backgroundSprite != null) {
            this.backgroundSprite.paint(g);
        }
        if (this.label != null) {
            g.setColor(0xFFFFFF);
            Font normalFont = this.font;
            if (this.buttonType == 20 || this.buttonType == 3) {
                if (this.displaySize == DisplaySizes.DOUGLAS_8 || this.displaySize == DisplaySizes.S60_3_1 || this.displaySize == DisplaySizes.S60_3_1_OLD) {
                    this.font = Font.getFont((int)0, (int)1, (int)16);
                    g.setFont(this.font);
                } else if (this.displaySize == DisplaySizes.S60_3_2_SDK || this.displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || this.displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK) {
                    this.font = Font.getFont((int)0, (int)1, (int)16);
                    g.setFont(this.font);
                } else if (this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NAV || this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NO_KEYBOARD) {
                    this.font = Font.getFont((int)0, (int)1, (int)16);
                    g.setFont(this.font);
                } else if (this.displaySize == DisplaySizes.TUBE_PORTRAIT_NAV || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NO_KEYBOARD) {
                    this.font = Font.getFont((int)0, (int)1, (int)16);
                    g.setFont(this.font);
                }
            }
            if (this.backgroundSprite.getFrame() == 1) {
                g.drawString(this.label, this.xPos + this.getLabelXOffset() + 2, this.yPos + this.getLabelYOffset() + 1, 20);
            } else {
                g.drawString(this.label, this.xPos + this.getLabelXOffset(), this.yPos + this.getLabelYOffset(), 20);
            }
            this.font = normalFont;
            g.setFont(this.font);
        }
        if (this.labelSprite != null) {
            if (this.buttonType == 28) {
                this.labelSprite.setTransform(3);
            } else {
                this.labelSprite.setTransform(0);
            }
            if (this.backgroundSprite.getFrame() == 1) {
                this.labelSprite.setPosition(this.xPos + this.getLabelXOffset() + 2, this.yPos + this.getLabelYOffset() + 1);
            } else {
                this.labelSprite.setPosition(this.xPos + this.getLabelXOffset(), this.yPos + this.getLabelYOffset());
            }
            this.labelSprite.paint(g);
        }
    }

    public void repaint() {
        if (this.buttonPanel != null) {
            this.buttonPanel.repaint();
        }
    }

    public void setXPos(int xPos) {
        super.setXPos(xPos);
        this.backgroundSprite.setPosition(xPos, this.yPos);
    }

    public void setYPos(int yPos) {
        super.setYPos(yPos);
        this.backgroundSprite.setPosition(this.xPos, yPos);
    }

    public synchronized void press() {
        if (this.editPanel != null) {
            this.drawPressedButton();
            this.editPanel.handlePressedButton(this.buttonType);
        }
    }

    public void setButtonPanel(ButtonPanel buttonPanel) {
        this.buttonPanel = buttonPanel;
    }

    public ButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void setEditPanel(EditPanel editPanel) {
        this.editPanel = editPanel;
    }

    public EditPanel getEditPanel() {
        return this.editPanel;
    }

    protected void drawPressedButton() {
        this.backgroundSprite.setFrame(1);
        this.repaint();
        Thread thread = new Thread(){

            public synchronized void run() {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (Button.this.highlighted) {
                    Button.this.backgroundSprite.setFrame(2);
                } else {
                    Button.this.backgroundSprite.setFrame(0);
                }
                Button.this.repaint();
            }
        };
        thread.start();
    }

    protected int getLabelXOffset() {
        if (this.label != null) {
            return (this.width - this.buttonShadeSize - this.font.stringWidth(this.label)) / 2;
        }
        if (this.labelSprite != null) {
            return (this.width - this.buttonShadeSize - this.labelSprite.getWidth()) / 2;
        }
        return 0;
    }

    protected int getLabelYOffset() {
        if (this.displaySize == DisplaySizes.DOUGLAS_8 || this.displaySize == DisplaySizes.S60_3_1 || this.displaySize == DisplaySizes.S60_3_1_OLD || this.displaySize == DisplaySizes.S60_3_2_SDK || this.displaySize == DisplaySizes.S60_3_2_LANDSCAPE_SDK || this.displaySize == DisplaySizes.S60_3_1_LANDSCAPE_SDK || this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NAV || this.displaySize == DisplaySizes.TUBE_LANDSCAPE_NO_KEYBOARD || this.displaySize == DisplaySizes.TUBE_LANDSCAPE_GAME || this.displaySize == DisplaySizes.TUBE_PORTRAIT_GAME || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NAV || this.displaySize == DisplaySizes.TUBE_PORTRAIT_NO_KEYBOARD) {
            if (this.label != null) {
                switch (this.buttonType) {
                    case 0: {
                        return 2;
                    }
                    case 1: {
                        return 1;
                    }
                    case 4: {
                        return 1;
                    }
                    case 5: {
                        return 1;
                    }
                    case 6: {
                        return 1;
                    }
                    case 7: {
                        return 3;
                    }
                    case 9: {
                        return 1;
                    }
                    case 10: {
                        return 1;
                    }
                    case 11: {
                        return 1;
                    }
                    case 15: {
                        return 1;
                    }
                    case 17: {
                        return 1;
                    }
                    case 18: {
                        return 1;
                    }
                    case 20: {
                        return -3;
                    }
                    case 21: {
                        return 1;
                    }
                    case 24: {
                        return 1;
                    }
                    case 25: {
                        return 1;
                    }
                    case 26: {
                        return 1;
                    }
                }
                return 0;
            }
            if (this.labelSprite != null) {
                return (this.height - this.buttonShadeSize - this.labelSprite.getHeight()) / 2;
            }
            return 0;
        }
        return 0;
    }

    public void setHighlighted(boolean highlighted) {
        super.setHighlighted(highlighted);
        if (highlighted) {
            this.backgroundSprite.setFrame(2);
        } else {
            this.backgroundSprite.setFrame(0);
        }
    }
}

